/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.coroutil.util.CU;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilEntity;
import com.corosus.coroutil.util.CoroUtilPath;
import com.corosus.coroutil.util.CoroUtilWorldTime;
import com.corosus.zombieawareness.EntityScent;
import com.corosus.zombieawareness.EnumSenseType;
import com.corosus.zombieawareness.ZombieAwareness;
import com.corosus.zombieawareness.client.SoundProfileEntry;
import com.corosus.zombieawareness.client.SoundRegistry;
import com.corosus.zombieawareness.config.ZAConfigFeatures;
import com.corosus.zombieawareness.config.ZAConfigGeneral;
import com.corosus.zombieawareness.config.ZAConfigPlayerLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2401;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3619;
import net.minecraft.class_5134;
import net.minecraft.class_9;
import org.joml.Vector3d;

public class ZAUtil {
    public static Random rand = new Random();
    public static HashMap<String, Integer> lastHealths = new HashMap();
    public static HashMap<String, Long> lastBleedTimes = new HashMap();
    public static List<SoundProfileEntry> listSoundProfiles = new ArrayList<SoundProfileEntry>();
    public static HashMap<String, SoundProfileEntry> lookupSoundNameToProfileCache = new HashMap();
    public static HashMap<Integer, SoundProfileEntry> lookupSoundIntToProfile = new HashMap();
    public static WeakHashMap<class_1297, Long> lookupLastAlertTime = new WeakHashMap();
    public static long alertDelay = 1200L;
    public static WeakHashMap<class_1297, Long> lookupLastInvestigateTime = new WeakHashMap();
    public static long investigateDelay = 1200L;
    public static HashMap<String, Long> lookupLastWaypointTime = new HashMap();
    public static HashMap<class_1299, Boolean> lookupTickableEntitiesCache = new HashMap();
    public static String SPEED_BOOST_TAG = "za_speedbosted";
    public static String ZA_LAST_ACTION = "za_last_action";
    public static boolean debug = false;

    public static void initSoundHookDataIfEmpty() {
        if (listSoundProfiles.size() == 0) {
            ZAUtil.addSoundHooks();
        }
    }

    public static void addSoundHooks() {
        int noisyInteractRange = 30;
        double noisyInteractBuff = 1.3;
        listSoundProfiles.clear();
        lookupSoundIntToProfile.clear();
        lookupSoundNameToProfileCache.clear();
        listSoundProfiles.add(new SoundProfileEntry(class_3417.field_15224, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(class_3417.field_15151, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(class_3417.field_14636, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(class_3417.field_14823, noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        ArrayList<Integer> listDoorSoundEvents = new ArrayList<Integer>();
        listDoorSoundEvents.add(1037);
        listDoorSoundEvents.add(1007);
        listDoorSoundEvents.add(1036);
        listDoorSoundEvents.add(1013);
        listDoorSoundEvents.add(1011);
        listDoorSoundEvents.add(1012);
        listDoorSoundEvents.add(1005);
        listDoorSoundEvents.add(1006);
        listDoorSoundEvents.add(1008);
        listDoorSoundEvents.add(1014);
        ZAUtil.addSoundIntegerEntry(new SoundProfileEntry("debug-doors", noisyInteractBuff).setListSoundEventTypes(listDoorSoundEvents));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1010);
        ZAUtil.addSoundIntegerEntry(new SoundProfileEntry("debug-records", 300.0).setListSoundEventTypes(list));
        listSoundProfiles.add(new SoundProfileEntry(".place", noisyInteractBuff));
        listSoundProfiles.add(new SoundProfileEntry("player.burp", 1.1));
        listSoundProfiles.add(new SoundProfileEntry("block.note", noisyInteractBuff).setMaxDistToSpawnFromPlayer(64.0));
        listSoundProfiles.add(new SoundProfileEntry("lever.click", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("pressure_plate", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("button.click", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("tripwire", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("block.barrel", noisyInteractBuff).setMaxDistToSpawnFromPlayer(noisyInteractRange));
        if (ZAConfigFeatures.noisyZombies) {
            listSoundProfiles.add(new SoundProfileEntry(class_3417.field_15174, 0.8, ZAConfigGeneral.noisyZombiesReinforceOddsTo1).setMaxDistToSpawnFromPlayer(18.0));
        }
        if (ZAConfigFeatures.noisyPistons) {
            listSoundProfiles.add(new SoundProfileEntry(class_3417.field_15134, 2.0, 5).setMaxDistToSpawnFromPlayer(24.0));
        }
        listSoundProfiles.add(new SoundProfileEntry((class_3414)class_3417.field_15152.comp_349(), 10.0).setMaxDistToSpawnFromPlayer(24.0));
    }

    public static void addSoundIntegerEntry(SoundProfileEntry entry) {
        for (int soundID : entry.getListSoundEventTypes()) {
            lookupSoundIntToProfile.put(soundID, entry);
        }
        listSoundProfiles.add(entry);
    }

    public static SoundProfileEntry getSoundIDEntry(int soundType) {
        return lookupSoundIntToProfile.get(soundType);
    }

    public static SoundProfileEntry getSoundIDEntry(String sound) {
        if (lookupSoundNameToProfileCache.containsKey(sound)) {
            return lookupSoundNameToProfileCache.get(sound);
        }
        for (SoundProfileEntry entry : listSoundProfiles) {
            if (entry.getSoundName().equals(sound)) {
                lookupSoundNameToProfileCache.put(sound, entry);
                return entry;
            }
            if (!entry.isPartialMatchOnly() || !sound.contains(entry.getSoundName())) continue;
            lookupSoundNameToProfileCache.put(sound, entry);
            return entry;
        }
        return null;
    }

    public static void tickPlayer(class_1657 player) {
        if (ZAConfigFeatures.wanderingHordes) {
            long lastWaypoint;
            long l = lastWaypoint = lookupLastWaypointTime.containsKey(CoroUtilEntity.getName((class_1297)player)) ? lookupLastWaypointTime.get(CoroUtilEntity.getName((class_1297)player)) : 0L;
            if (lastWaypoint < System.currentTimeMillis()) {
                lastWaypoint = System.currentTimeMillis() + (long)ZAConfigFeatures.frequencyOfWanderingHordesPerPlayer * 1000L;
                lookupLastWaypointTime.put(CoroUtilEntity.getName((class_1297)player), lastWaypoint);
                ZAUtil.spawnWaypoint((class_1297)player);
            }
        }
        if (ZAConfigFeatures.awareness_Scent && !player.method_7337()) {
            EntityScent scent;
            int lastHealth = lastHealths.containsKey(CoroUtilEntity.getName((class_1297)player)) ? lastHealths.get(CoroUtilEntity.getName((class_1297)player)) : 0;
            Long lastBleedTime = lastBleedTimes.containsKey(CoroUtilEntity.getName((class_1297)player)) ? lastBleedTimes.get(CoroUtilEntity.getName((class_1297)player)) : 0L;
            Vector3d pos = new Vector3d(player.method_23317(), player.method_23318(), player.method_23321());
            if ((int)player.method_6032() != lastHealth) {
                if (player.method_6032() < (float)lastHealth) {
                    scent = ZAUtil.spawnOrBuffSenseAtPos(player.method_37908(), pos, EnumSenseType.SCENT_BLOOD, ZAConfigGeneral.scentStrength);
                    ZombieAwareness.dbg("spawned or buffed scent sense from damage: " + scent.getStrengthPeak());
                }
                lastHealth = (int)player.method_6032();
            }
            lastHealths.put(CoroUtilEntity.getName((class_1297)player), lastHealth);
            if (player.method_6032() / player.method_6063() < 0.6f && lastBleedTime < System.currentTimeMillis()) {
                lastBleedTime = System.currentTimeMillis() + 30000L;
                lastBleedTimes.put(CoroUtilEntity.getName((class_1297)player), lastBleedTime);
                scent = ZAUtil.spawnOrBuffSenseAtPos(player.method_37908(), pos, EnumSenseType.SCENT_BLOOD, ZAConfigGeneral.scentStrength);
                ZombieAwareness.dbg("spawned or buffed scent sense from bleeding: " + scent.getStrengthPeak());
            }
        }
    }

    public static void processMobSpawn(class_1309 ent) {
        if (ZAConfigGeneral.zombieRandSpeedBoost > 0.0 && ent instanceof class_1642 && !ZAUtil.isMobSpeedBosted((class_1308)ent)) {
            ZAUtil.giveRandomSpeedBoost((class_1308)ent);
        }
    }

    public static boolean isMobSpeedBosted(class_1308 ent) {
        return ZombieAwareness.instance().getPersistentData((class_1297)ent).method_10577(SPEED_BOOST_TAG);
    }

    public static void giveRandomSpeedBoost(class_1308 ent) {
        if (ZAConfigGeneral.zombieRandSpeedBoost > 0.0) {
            double randBoost = CU.rand().nextDouble() * ZAConfigGeneral.zombieRandSpeedBoost;
            if (ent.method_6109()) {
                randBoost *= -1.0;
            }
            class_2960 resourceLocation = class_2960.method_60655((String)"zombieawareness", (String)"speed_boost");
            class_1322 speedBoostModifier = new class_1322(resourceLocation, randBoost, class_1322.class_1323.field_6330);
            if (!ent.method_5996(class_5134.field_23719).method_6196(speedBoostModifier.comp_2447())) {
                ZombieAwareness.dbg("boosting zombie speed to " + randBoost);
                ent.method_5996(class_5134.field_23719).method_26837(speedBoostModifier);
                ZombieAwareness.instance().getPersistentData((class_1297)ent).method_10556(SPEED_BOOST_TAG, true);
            }
        }
    }

    public static void huntTarget(class_1308 ent, class_1309 targ, int pri) {
        CoroUtilPath.tryMoveToEntityLivingLongDist((class_1308)ent, (class_1297)targ, (double)1.0);
        if (ent instanceof class_1308) {
            ent.method_5980(targ);
        }
    }

    public static void huntTarget(class_1308 ent, class_1309 targ) {
        ZAUtil.huntTarget(ent, targ, 0);
    }

    public static boolean isEnemy(class_1297 ent, class_1297 targ) {
        return ZAUtil.isEnemy(ent, targ, false);
    }

    public static boolean isEnemy(class_1297 ent, class_1297 targ, boolean omniTarget) {
        if (targ instanceof class_1309) {
            if (targ instanceof class_1657 && !((class_1657)targ).method_7337() && ((class_1657)targ).method_6112(class_1294.field_5905) == null) {
                if (!omniTarget) {
                    return true;
                }
                if (ZAConfigPlayerLists.whiteListUsedOmniscient) {
                    if (ZAConfigPlayerLists.whitelistOmniscientTargettedPlayers.contains(CoroUtilEntity.getName((class_1297)((class_1657)targ)))) {
                        if (ZAConfigGeneral.debugConsoleOmniscient) {
                            ZombieAwareness.dbg(CoroUtilEntity.getName((class_1297)((class_1657)targ)) + " targetting omnisciently by " + String.valueOf(ent));
                        }
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean sanityCheck(class_1297 ent, class_1297 entity1) {
        return true;
    }

    public static void markPerformedPathing(class_1308 ent) {
        ent.method_16826(0);
        ZombieAwareness.instance().getPersistentData((class_1297)ent).method_10544(ZA_LAST_ACTION, ent.method_37908().method_8510());
    }

    public static void tickAI(class_1308 ent) {
        class_1657 player;
        class_9 pathTo;
        long lastActionTime;
        if (!ZAUtil.isZombieAwarenessActive(ent.method_37908())) {
            return;
        }
        if (ZAConfigGeneral.debugConsoleSuperDetailed) {
            ZombieAwareness.dbg("ZA DBG: Ticking: " + String.valueOf(ent));
        }
        if ((lastActionTime = ZombieAwareness.instance().getPersistentData((class_1297)ent).method_10537(ZA_LAST_ACTION)) > 0L && ent.method_37908().method_8510() - (long)ZAConfigGeneral.tickCooldownBetweenPathfinds < lastActionTime) {
            return;
        }
        if ((ent.method_37908().method_8510() + (long)ent.method_5628()) % 40L == 0L) {
            if (ZAConfigGeneral.omniscient && ent.method_5968() == null) {
                ZAUtil.ai_FindTarget(ent, true);
            } else {
                ZAUtil.ai_FindTarget(ent, false);
            }
        }
        EntityScent senseTracked = null;
        if (ent.method_5968() == null && ent.method_5942().method_6357()) {
            if (!ZAConfigGeneral.awareness_Light_OnlyZombies || ent instanceof class_1642) {
                if (!(ZAConfigFeatures.awareness_Light && ZAUtil.ai_FindLightSource(ent) || CU.rand().nextInt(3) != 0)) {
                    senseTracked = ZAUtil.ai_FindSense(ent, true);
                }
            } else {
                senseTracked = ZAUtil.ai_FindSense(ent);
            }
        }
        if (senseTracked != null && ent.method_5942().method_6345() != null && (pathTo = ent.method_5942().method_6345().method_45()) != null && (player = ZAUtil.getClosestPlayer(ent.method_37908(), pathTo.field_40, pathTo.field_39, pathTo.field_38, 6.0)) != null) {
            ZAUtil.tryPlayInvestigateSound(ent, new Vector3d((double)pathTo.field_40, (double)pathTo.field_39, (double)pathTo.field_38));
        }
        ZAUtil.tickCustomMob(ent);
    }

    public static void tickCustomMob(class_1308 ent) {
        if (ZAConfigFeatures.wanderingHordes && ent instanceof class_1628 && ent.method_5685().size() > 0 && ent.method_5685().get(0) instanceof class_1613 && CU.rand().nextInt(100) == 0) {
            ZAUtil.spawnWaypoint((class_1297)ent);
        }
    }

    public static boolean ai_FindLightSource(class_1308 ent) {
        if (ent.method_37908().method_8530()) {
            return false;
        }
        boolean forceOn = false;
        if (forceOn || CU.rand().nextInt(3) == 0) {
            float lightValueAtEntity = ent.method_37908().method_8314(class_1944.field_9282, ent.method_24515());
            Random rand = new Random();
            for (int i = 0; i < 4; ++i) {
                boolean canSeePos;
                class_1657 entP = ZAUtil.getClosestPlayerToEntity(ent.method_37908(), (class_1297)ent, 999.0);
                if (entP == null) continue;
                int size = 32 * (i + 1);
                int rX = (int)Math.floor(entP.method_23317() + (double)(rand.nextInt(size) - size / 2));
                int rY = (int)Math.floor(entP.method_23318() + (double)(rand.nextInt(size / 2) - size / 4));
                int rZ = (int)Math.floor(entP.method_23321() + (double)(rand.nextInt(size) - size / 2));
                class_2338 pos = new class_2338(rX, rY, rZ);
                if (!ent.method_37908().method_8477(pos)) continue;
                float lightValueNearPlayer = entP.method_37908().method_8314(class_1944.field_9282, pos);
                if (!forceOn && (!(lightValueNearPlayer > 0.2f) || !(lightValueNearPlayer >= lightValueAtEntity)) || !forceOn && CU.rand().nextInt(5) != 0 || !(ent.method_5739((class_1297)entP) > 16.0f) || !(canSeePos = CoroUtilEntity.canSee((class_1297)ent, (class_2338)new class_2338(rX, rY, rZ)))) continue;
                ZombieAwareness.dbg("try path to light source - " + rX + ", " + rY + ", " + rZ);
                ent.method_37908().method_16107().method_15396("zombieawareness_pathfind");
                boolean pathFound = CoroUtilPath.tryMoveToXYZLongDist((class_1308)ent, (double)rX, (double)rY, (double)rZ, (double)1.0);
                ent.method_37908().method_16107().method_15407();
                if (pathFound) {
                    ZombieAwareness.dbg("node count: " + ent.method_5942().method_6345().method_38());
                    ZombieAwareness.dbg("pathing to lightsource at " + rX + ", " + rY + ", " + rZ + " - " + String.valueOf(ent));
                    ZAUtil.markPerformedPathing(ent);
                }
                return true;
            }
        }
        return false;
    }

    public static EntityScent ai_FindSense(class_1308 ent) {
        return ZAUtil.ai_FindSense(ent, true);
    }

    public static EntityScent ai_FindSense(class_1308 ent, boolean includeWaypoints) {
        EntityScent var3 = ZAUtil.getSenseNearEntity((class_1297)ent);
        if (var3 != null && (includeWaypoints || var3.getSenseType() != 2)) {
            ent.method_37908().method_16107().method_15396("zombieawareness_pathfind");
            boolean pathFound = CoroUtilPath.tryMoveToEntityLivingLongDist((class_1308)ent, (class_1297)var3, (double)1.0);
            ent.method_37908().method_16107().method_15407();
            if (pathFound) {
                ZAUtil.markPerformedPathing(ent);
                ZombieAwareness.dbg("ai_FindSense call, type: " + var3.getSenseType() + " - " + String.valueOf(ent.method_5477()) + " -> " + String.valueOf(var3.method_19538()));
                return var3;
            }
        }
        return null;
    }

    public static boolean ai_FindTarget(class_1308 ent, boolean omniscient) {
        long huntRange = ZAConfigGeneral.sightRange;
        if (omniscient) {
            huntRange = 512L;
        }
        if (ent.method_5968() == null || CU.rand().nextInt(100) == 0) {
            boolean found = false;
            class_1297 clEnt = null;
            float closest = 9999.0f;
            List list = ent.method_37908().method_8335((class_1297)ent, ent.method_5829().method_1009((double)huntRange, (double)(huntRange / 2L), (double)huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                class_1297 entity1 = (class_1297)list.get(j);
                if (ent.getClass().getSimpleName().equals("EntityZombiePlayer") || !ZAUtil.isEnemy((class_1297)ent, entity1, omniscient) || !omniscient && !ZAConfigGeneral.seeThroughWalls && !((class_1309)entity1).method_6057((class_1297)ent) || !ZAUtil.sanityCheck((class_1297)ent, entity1) || !((dist = (float)ent.method_5858(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                ZAUtil.huntTarget(ent, (class_1309)clEnt);
                ZAUtil.markPerformedPathing(ent);
                ZombieAwareness.dbg(" hunting target " + String.valueOf(ent) + " " + String.valueOf(clEnt));
                return true;
            }
        }
        return false;
    }

    public static EntityScent getSenseNearEntity(class_1297 entSource) {
        List listEnts = entSource.method_37908().method_8335(entSource, entSource.method_5829().method_1009((double)ZAConfigGeneral.maxPFRangeSense, (double)ZAConfigGeneral.maxPFRangeSense, (double)ZAConfigGeneral.maxPFRangeSense));
        EntityScent bestEnt = null;
        float bestRangeAkaStrength = 0.0f;
        double bestDist = 9999.0;
        float rangeTooClose = 5.0f;
        int randChance = 10;
        float percentChance = (float)ZAConfigGeneral.findSense_PercentChance / 100.0f;
        if (CU.rand().nextFloat() <= percentChance) {
            for (int i = 0; i < listEnts.size(); ++i) {
                class_1297 entCheck = (class_1297)listEnts.get(i);
                if (!(entCheck instanceof EntityScent)) continue;
                EntityScent entityScent = (EntityScent)entCheck;
                double dist = entSource.method_5739(entCheck);
                if (!(entityScent.getRange() > bestRangeAkaStrength) || !(dist < (double)entityScent.getRange()) || entityScent.getSenseType() == 2 && CU.rand().nextInt(2) != 0) continue;
                bestEnt = (EntityScent)entCheck;
                bestRangeAkaStrength = entityScent.getRange();
                bestDist = dist;
            }
            if (bestDist <= (double)rangeTooClose) {
                return null;
            }
        }
        return bestEnt;
    }

    public static void hookPlayEvent(int type, class_1937 world, double pX, double pY, double pZ, int data) {
        class_1657 closestPlayer;
        ZAUtil.initSoundHookDataIfEmpty();
        if (world.method_8608() || !ZAUtil.canSpawnTraceQuickCheck(world)) {
            return;
        }
        SoundProfileEntry entry = ZAUtil.getSoundIDEntry(type);
        if (entry != null && (closestPlayer = ZAUtil.getClosestPlayer(world, pX, pY, pZ, entry.getMaxDistToSpawnFromPlayer())) != null) {
            Vector3d pos = new Vector3d(pX, pY, pZ);
            if (!ZAUtil.canSpawnTrace(world, pX, pY, pZ)) {
                return;
            }
            ZAUtil.handleSoundProfileEvent(world, entry, pos, closestPlayer);
        }
    }

    public static void hookSoundEventClient(class_3414 sound, class_1937 world, double x, double y, double z, float volume, float pitch) {
        class_1657 closestPlayer = ZAUtil.getClosestPlayer(world, x, y, z, 5.0);
        if (closestPlayer != null) {
            System.out.println("client sound heard: " + SoundProfileEntry.getSoundEventName(sound));
        }
    }

    public static void hookSoundEvent(class_3414 sound, class_1937 world, double x, double y, double z, float volume, float pitch) {
        class_1657 closestPlayer;
        ZAUtil.initSoundHookDataIfEmpty();
        if (world.method_8608() || sound == null || !ZAUtil.canSpawnTraceQuickCheck(world)) {
            return;
        }
        String soundName = SoundProfileEntry.getSoundEventName(sound);
        SoundProfileEntry entry = ZAUtil.getSoundIDEntry(soundName);
        if (entry != null && (closestPlayer = ZAUtil.getClosestPlayer(world, x, y, z, entry.getMaxDistToSpawnFromPlayer())) != null) {
            Vector3d pos = new Vector3d(x, y, z);
            if (!ZAUtil.canSpawnTrace(world, x, y, z) && !ZAUtil.canSpawnTrace(world, x, y += 1.0, z)) {
                return;
            }
            ZAUtil.handleSoundProfileEvent(world, entry, pos, closestPlayer);
        }
    }

    public static void handleSoundProfileEvent(class_1937 world, SoundProfileEntry entry, Vector3d pos, class_1657 closestPlayer) {
        double distToPlayer = Math.sqrt(closestPlayer.method_5649(pos.x, pos.y, pos.z));
        double strength = ZAConfigGeneral.soundStrength;
        if (distToPlayer <= entry.getMaxDistToSpawnFromPlayer() && (entry.getOddsTo1ToUse() <= 0 || rand.nextInt(entry.getOddsTo1ToUse()) == 0)) {
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, pos, EnumSenseType.SOUND, (int)(strength *= entry.getMultiplier()));
            ZombieAwareness.dbg("spawned or buffed sound sense from soundEvent, sound: " + entry.getSoundName() + ", str: " + scent.getStrengthPeak());
        }
    }

    public static void hookBlockEvent(class_1657 player, int chance) {
        if (player != null && !ZAUtil.canSpawnTraceQuickCheck(player.method_37908())) {
            return;
        }
        if (player == null || ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((class_1297)player))) {
            return;
        }
        if (!player.method_37908().method_8608() && CU.rand().nextInt(chance) == 0) {
            int strength = ZAConfigGeneral.soundStrength;
            Vector3d pos = new Vector3d(player.method_23317(), player.method_23318(), player.method_23321());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(player.method_37908(), pos, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from PlayerEvent: " + scent.getStrengthPeak());
        }
    }

    public static void handleBlockBasedEvent(class_1657 player, class_1937 world, class_2338 pos, int chance) {
        if (player == null && ZAConfigGeneral.blockBreakEvent_PlayersOnly) {
            return;
        }
        if (!ZAUtil.canSpawnTraceQuickCheck(world)) {
            return;
        }
        if (player != null && ZAConfigPlayerLists.whiteListUsedSenses && ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((class_1297)player))) {
            return;
        }
        if (!world.method_8608() && CU.rand().nextInt(chance) == 0) {
            int strength = ZAConfigGeneral.soundStrength;
            Vector3d posVec = new Vector3d((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, posVec, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from BlockBasedEvent: " + scent.getStrengthPeak());
        }
    }

    public static void test(Object ... args) {
    }

    public static void hookSetAttackTarget(class_1309 entity, class_1309 target) {
        if (entity instanceof class_1308) {
            if (target instanceof class_1657) {
                ZAUtil.tryPlayTargetSound((class_1308)entity, target, new Vector3d(entity.method_23317(), entity.method_23318(), entity.method_23321()));
            } else if (target == null) {
                // empty if block
            }
        }
    }

    public static void spawnWaypoint(class_1297 entSource) {
        int range = 128;
        double tryX = (int)entSource.method_23317() - range / 2 + rand.nextInt(range);
        double tryZ = (int)entSource.method_23321() - range / 2 + rand.nextInt(range);
        double tryY = entSource.method_37908().method_8624(class_2902.class_2903.field_13197, (int)Math.floor(tryX), (int)Math.floor(tryZ));
        if (!ZAUtil.canSpawnTrace(entSource.method_37908(), tryX, tryY, tryZ)) {
            return;
        }
        double height = entSource.method_23318();
        EntityScent var1 = ZAUtil.getSenseNodeAtPos(entSource.method_37908(), new Vector3d(tryX, tryY, tryZ), EnumSenseType.WAYPOINT);
        boolean newNode = false;
        if (var1 == null) {
            var1 = new EntityScent(ZombieAwareness.SENSE, entSource.method_37908());
            newNode = true;
        }
        var1.setStrengthPeak(150);
        if (newNode) {
            var1.method_5814(tryX, tryY, tryZ);
            var1.setSenseType(2);
            entSource.method_37908().method_8649((class_1297)var1);
        }
        if (debug) {
            System.out.println("WP: " + String.valueOf(entSource) + " - range: " + var1.getRange());
        }
    }

    public static boolean canSpawnTraceQuickCheck(class_1937 world) {
        if (!ZAConfigFeatures.awareness_Sound) {
            return false;
        }
        return !ZAConfigFeatures.awareness_Sound_OverworldOnly || world.method_27983() == class_1937.field_25179;
    }

    public static boolean canSpawnTrace(class_1937 world, double x, double y, double z) {
        class_2338 pos = CoroUtilBlock.blockPos((double)x, (double)y, (double)z);
        if (!world.method_8477(pos)) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        return state.method_26223() != class_3619.field_15971 || state.method_26204() instanceof class_2269 || state.method_26204() instanceof class_2401;
    }

    public static class_1657 getClosestPlayerToEntity(class_1937 world, class_1297 par1Entity, double par2) {
        return ZAUtil.getClosestPlayer(world, par1Entity.method_23317(), par1Entity.method_23318(), par1Entity.method_23321(), par2);
    }

    public static class_1657 getClosestPlayer(class_1937 world, double x, double y, double z, double maxDistance) {
        double closestDist = -1.0;
        class_1657 closestPlayer = null;
        for (int i = 0; i < world.method_18456().size(); ++i) {
            class_1657 entityplayer1 = (class_1657)world.method_18456().get(i);
            if (ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((class_1297)entityplayer1))) continue;
            double d5 = entityplayer1.method_5649(x, y, z);
            if (!(maxDistance < 0.0) && !(d5 < maxDistance * maxDistance) || closestDist != -1.0 && !(d5 < closestDist)) continue;
            closestDist = d5;
            closestPlayer = entityplayer1;
        }
        return closestPlayer;
    }

    public static EntityScent getSenseNodeAtPos(class_1937 parWorld, Vector3d parPos, EnumSenseType type) {
        if (ZAConfigGeneral.extraScentCutoffRange == -1.0) {
            return null;
        }
        class_238 aabb = new class_238(parPos.x, parPos.y, parPos.z, parPos.x + 1.0, parPos.y + 1.0, parPos.z + 1.0);
        List list = parWorld.method_18467(EntityScent.class, aabb = aabb.method_1009(ZAConfigGeneral.extraScentCutoffRange, ZAConfigGeneral.extraScentCutoffRange, ZAConfigGeneral.extraScentCutoffRange));
        if (list.size() > 0) {
            for (int j = 0; j < list.size(); ++j) {
                EntityScent node = (EntityScent)((Object)list.get(j));
                if (node.getSenseType() != type.ordinal()) continue;
                return node;
            }
        }
        return null;
    }

    public static EntityScent spawnOrBuffSenseAtPos(class_1937 world, Vector3d parPos, EnumSenseType type, int strength) {
        return ZAUtil.spawnOrBuffSenseAtPos(world, parPos, type, strength, true);
    }

    public static EntityScent spawnOrBuffSenseAtPos(class_1937 world, Vector3d parPos, EnumSenseType type, int strength, boolean frequentSoundMultiply) {
        EntityScent sense = ZAUtil.getSenseNodeAtPos(world, parPos, type);
        if (sense == null) {
            sense = new EntityScent(ZombieAwareness.SENSE, world);
            sense.setSenseType(type.ordinal());
            sense.method_5814(parPos.x, parPos.y, parPos.z);
            sense.setStrengthPeak(strength);
            world.method_8649((class_1297)sense);
        } else if (frequentSoundMultiply) {
            float str = sense.getStrengthPeak();
            if (str < (float)strength) {
                str = strength;
            }
            if (sense.lastBuffTime + (long)ZAConfigGeneral.frequentSoundThreshold > System.currentTimeMillis()) {
                sense.lastMultiply += 0.1f;
                str *= sense.lastMultiply;
            } else {
                sense.lastMultiply = 1.0f;
            }
            sense.lastBuffTime = System.currentTimeMillis();
            sense.setStrengthPeak((int)str);
        }
        return sense;
    }

    public static void tryPlayTargetSound(class_1308 entAlerted, class_1309 entTargetted, Vector3d pos) {
        if (!ZAConfigFeatures.soundAlerts) {
            return;
        }
        if (!ZAConfigFeatures.soundAlertsForAllAttackingMobs && !ZombieAwareness.canProcessEntity((class_1297)entAlerted)) {
            return;
        }
        double distMaxCancel = 75.0;
        if ((!lookupLastAlertTime.containsKey(entAlerted) || lookupLastAlertTime.get(entAlerted) + alertDelay < entAlerted.method_37908().method_8510()) && (double)entAlerted.method_5739((class_1297)entTargetted) < distMaxCancel && entAlerted.method_37908().method_27983() == entTargetted.method_37908().method_27983() && entAlerted.method_37908().method_8477(entAlerted.method_24515()) && entTargetted.method_37908().method_8477(entTargetted.method_24515())) {
            if (entAlerted.method_6057((class_1297)entTargetted)) {
                entAlerted.method_37908().method_43128(null, entTargetted.method_23317(), entTargetted.method_23318(), entTargetted.method_23321(), ZAConfigFeatures.soundUseAlternateAlertNoise ? SoundRegistry.get("alert") : SoundRegistry.get("target"), class_3419.field_15251, (float)ZAConfigFeatures.soundVolumeAlertTarget, ZAConfigFeatures.soundUseAlternateAlertNoise ? 1.0f : 0.8f + CU.rand().nextFloat() * 0.2f);
                lookupLastAlertTime.put((class_1297)entAlerted, entAlerted.method_37908().method_8510());
            } else {
                ZAUtil.tryPlayInvestigateSound(entAlerted, pos);
            }
        }
    }

    public static void tryPlayInvestigateSound(class_1308 entAlerted, Vector3d pos) {
        if (!ZAConfigFeatures.soundInvestigates) {
            return;
        }
        if (!ZombieAwareness.canProcessEntity((class_1297)entAlerted)) {
            return;
        }
        if (!lookupLastInvestigateTime.containsKey(entAlerted) || lookupLastInvestigateTime.get(entAlerted) + investigateDelay < entAlerted.method_37908().method_8510()) {
            entAlerted.method_37908().method_43128(null, pos.x, pos.y, pos.z, SoundRegistry.get("investigate"), class_3419.field_15251, (float)ZAConfigFeatures.soundVolumeInvestigate, 0.7f + CU.rand().nextFloat() * 0.3f);
            lookupLastInvestigateTime.put((class_1297)entAlerted, entAlerted.method_37908().method_8510());
            ZombieAwareness.dbg("!!! investigate play for ent: " + entAlerted.method_5628() + ", lookupSize: " + lookupLastInvestigateTime.size());
        }
    }

    public static boolean isZombieAwarenessActive(class_1937 world) {
        if (world == null) {
            return false;
        }
        if (ZAConfigGeneral.daysBeforeFeaturesActivate <= 0.0) {
            return true;
        }
        double day = (double)world.method_8532() / (double)CoroUtilWorldTime.getDayLength();
        return day >= ZAConfigGeneral.daysBeforeFeaturesActivate;
    }
}

